/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.screen.potion_bag;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.items.PotionBagItem;
import zabi.minecraft.extraalchemy.screen.ModScreenHandlerTypes;
import zabi.minecraft.extraalchemy.screen.potion_bag.BagInventory;
import zabi.minecraft.extraalchemy.screen.potion_bag.FakeSelectionInventory;
import zabi.minecraft.extraalchemy.utils.PotionUtilities;

public class PotionBagScreenHandler
extends class_1703 {
    protected BagInventory bagInventory;
    protected FakeSelectionInventory fakeInventory;
    protected class_1661 playerInventory;
    protected class_1799 bagStack;

    public PotionBagScreenHandler(int syncId, class_1661 playerInventory, class_1657 player, class_1268 hand) {
        super(ModScreenHandlerTypes.POTION_BAG, syncId);
        if (hand == null) {
            class_1792 mainHand = player.method_6047().method_7909();
            class_1792 offHand = player.method_6079().method_7909();
            if (mainHand == ModItems.POTION_BAG) {
                hand = class_1268.field_5808;
            } else if (offHand == ModItems.POTION_BAG) {
                hand = class_1268.field_5810;
            }
        }
        this.bagStack = player.method_5998(hand);
        this.playerInventory = playerInventory;
        this.bagInventory = new BagInventory(this.bagStack, hand);
        this.fakeInventory = new FakeSelectionInventory();
        this.method_7621(new SelectorSlot(this.fakeInventory, this.bagStack, 80, 36));
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 9; ++i) {
                this.method_7621(new PotionOnlySlot(this.bagInventory, i + 9 * j, 18 * i + 8, 18 * j + 90));
            }
        }
        this.addPlayerSlots(playerInventory, 8, 140);
    }

    public PotionBagScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, playerInventory.field_7546, null);
    }

    protected void addPlayerSlots(class_1661 playerInventory, int x, int y) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (((class_1799)playerInventory.field_7547.get(j + i * 9 + 9)).method_7909() == ModItems.POTION_BAG) {
                    this.method_7621(new BagLockedSlot((class_1263)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
                    continue;
                }
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (((class_1799)playerInventory.field_7547.get(i)).method_7909() == ModItems.POTION_BAG) {
                this.method_7621(new BagLockedSlot((class_1263)playerInventory, i, x + i * 18, y + 58));
                continue;
            }
            this.method_7621(new class_1735((class_1263)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 player) {
        this.bagInventory.method_5432(player);
        this.fakeInventory.method_5432(player);
        player.method_31548().method_5431();
        player.method_31548().method_5432(player);
        super.method_7595(player);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return stack.method_7909() != ModItems.POTION_BAG && slot.method_7677().method_7909() != ModItems.POTION_BAG && slot.method_7680(stack);
    }

    public boolean method_7615(class_1735 slot) {
        return super.method_7615(slot) && !(slot instanceof BagLockedSlot);
    }

    protected boolean method_7616(class_1799 stack, int startIndex, int endIndex, boolean fromLast) {
        if (stack.method_7909() == ModItems.POTION_BAG) {
            return false;
        }
        return super.method_7616(stack, startIndex, endIndex, fromLast);
    }

    public void method_7593(int slotId, int mouseButton, class_1713 actionType, class_1657 player) {
        if (actionType == class_1713.field_7791) {
            return;
        }
        if (slotId != 0 || actionType == class_1713.field_7796 && player.method_31549().field_7477 && this.method_34255().method_7960()) {
            super.method_7593(slotId, mouseButton, actionType, player);
            return;
        }
        if (actionType != class_1713.field_7790) {
            return;
        }
        class_1799 iso = this.method_34255();
        if (!iso.method_7960()) {
            if (PotionUtilities.hasPotionEffects(iso)) {
                class_1799 nis = iso.method_7972();
                nis.method_7939(1);
                ((class_1735)this.field_7761.get(slotId)).method_7673(nis);
            }
        } else {
            ((class_1735)this.field_7761.get(slotId)).method_7673(class_1799.field_8037);
        }
        this.playerInventory.method_5431();
    }

    public class_1799 method_7601(class_1657 player, int index) {
        if (index > 18) {
            return this.transferToBag(player, index);
        }
        return this.transferToPlayer(player, index);
    }

    private class_1799 transferToBag(class_1657 player, int index) {
        return this.mergeAndUpdate(player, (class_1735)this.field_7761.get(index), index, 1, 19, false);
    }

    private class_1799 transferToPlayer(class_1657 player, int index) {
        return this.mergeAndUpdate(player, (class_1735)this.field_7761.get(index), index, 19, 55, true);
    }

    protected class_1799 mergeAndUpdate(class_1657 player, class_1735 slot, int slotIndex, int startIndex, int stopIndex, boolean reversed) {
        class_1799 origStack = slot.method_7677();
        class_1799 copyStack = origStack.method_7972();
        if (!this.method_7616(origStack, startIndex, stopIndex, reversed)) {
            return class_1799.field_8037;
        }
        slot.method_7670(origStack, copyStack);
        if (origStack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        if (origStack.method_7947() == copyStack.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7667(player, origStack);
        return origStack;
    }

    public static class SelectorSlot
    extends class_1735 {
        private class_1799 bagStack;

        public SelectorSlot(class_1263 inventory, class_1799 stack, int x, int y) {
            super(inventory, 0, x, y);
            this.bagStack = stack;
        }

        public void method_7670(class_1799 originalItem, class_1799 itemStack) {
        }

        public void method_7667(class_1657 player, class_1799 stack) {
            PotionBagItem.selectPotion(this.bagStack, null);
            this.method_7668();
        }

        public boolean method_7680(class_1799 stack) {
            return PotionUtilities.hasPotionEffects(stack);
        }

        public int method_7675() {
            return 1;
        }

        public class_1799 method_7677() {
            Optional<class_1844> selectedOpt = ModItems.POTION_BAG.getSelectedPotion(this.bagStack);
            if (selectedOpt.isEmpty()) {
                return class_1799.field_8037;
            }
            class_1844 pcc = selectedOpt.get();
            if (!pcc.method_57405()) {
                return class_1799.field_8037;
            }
            class_1799 stack = new class_1799(class_7923.field_41178.method_47983((Object)class_1802.field_8574), 1, class_9326.method_57841().method_57854(class_9334.field_49651, (Object)pcc).method_57852());
            return stack;
        }

        public void method_7673(class_1799 stack) {
            PotionBagItem.selectPotion(this.bagStack, stack);
            this.method_7668();
        }

        public class_1799 method_7671(int amount) {
            PotionBagItem.selectPotion(this.bagStack, null);
            this.method_7668();
            return class_1799.field_8037;
        }
    }

    public static class PotionOnlySlot
    extends class_1735 {
        public PotionOnlySlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7680(class_1799 stack) {
            return PotionBagItem.isValidPotionItem(stack);
        }
    }

    public static class BagLockedSlot
    extends class_1735 {
        public BagLockedSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return false;
        }

        public void method_7673(class_1799 stack) {
        }

        public class_1799 method_7671(int amount) {
            return class_1799.field_8037;
        }

        public boolean method_7682() {
            return true;
        }
    }
}

